/****************************************************************** 
 *
 *    Powered By tianxia-online. 
 *
 *    Copyright (c) 2018-2020 Digital Telemedia 天下科技 
 *    http://www.d-telemedia.com/ 
 *
 *    Package:     com.tx.platform.thirdpartypay.service.impl.v2 
 *
 *    Filename:    DCZFServiceImpl.java 
 *
 *    Description: TODO(用一句话描述该文件做什么) 
 *
 *    Copyright:   Copyright (c) 2018-2020 
 *
 *    Company:     天下科技 
 *
 *    @author:     Finlay 
 *
 *    @version:    1.0.0 
 *
 *    Create at:   2019年05月12日 11:02 
 *
 *    Revision: 
 *
 *    2019/5/12 11:02 
 *        - first revision 
 *
 *****************************************************************/
package com.tx.platform.thirdpartypay.service.impl.v2;

import com.alibaba.fastjson.JSONObject;
import com.tx.platform.thirdpartypay.po.BankPayResult;
import com.tx.platform.thirdpartypay.po.ScanPayResult;
import com.tx.platform.thirdpartypay.service.ThirdPartyPayServiceTemplate;
import com.tx.platform.thirdpartypay.util.DepositHttpClientUtils;
import com.tx.platform.thirdpartypay.util.RandomUtils;
import com.tx.platform.thirdpartypay.util.ThirdPayServiceFactory;
import com.tx.platform.thirdpartypay.vo.PaymentVO;
import com.tx.platform.utils.IPUtils;
import com.tx.platform.utils.MD5Utils;
import com.tx.platform.utils.ParamsUtils;
import com.tx.platform.utils.SHA256WithRSAUtils;
import com.tx.platform.vo.ProcessNotifyVO;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/**
 *  * @ClassName DCZFServiceImpl
 *  * @Description 聚合支付
 *  * @Author Finlay
 *  * @Date 2019年05月17日 15:22
 *  * @Version 1.0.0
 *  
 **/
@Data
@Service
@Slf4j
public class XDCZFPayServiceImpl extends ThirdPartyPayServiceTemplate {

    private PayConfig config = new PayConfig();
    /***请求返回编码KEY***/
    private static final String RETURN_CODE = "code";

    /**商户私钥KEY，用于支付签名（RSA2加密）*/
    private static final String SIGN_PRIVATE_KEY = "商户私钥";

    /**平台公钥KEY,用于回调验签（RSA2解密）*/
    private static final String SIGN_PUBLIC_KEY = "平台公钥";
    public XDCZFPayServiceImpl(){
        ThirdPayServiceFactory.putPayService(PayContants.CODE,this);
    }

    private static class PayContants{
        /**支付回调失败**/
        private static final String FAIL = "fail";

        /**下单请求成功返回code**/
        private static final String SUCCESS_CODE = "1";

        /**支付回调成功**/
        private static final String SUCCESS = "success";

        /**支付商编码 东川支付**/
        private static final String CODE = "XDCZF";

        /**class name**/
        private static final String CLASS_NAME = "XDCZFPayServiceImpl";
    }



    /***内部类用于封装配置参数***/
    @Data
    private static class PayConfig extends BasePayConfig{
        /***商户号***/
        private String payMemberid;
        /***支付请求地址***/
        private String payUrl;
        /***回调地址***/
        private String payNotifyUrl;
        /***密钥***/
        private String md5Key;
        /**支付订单查询url**/
        private String orderQueryUrl;

    }



    /**
     * 东川支付在线扫码
     * @param vo
     * @return
     * @throws Exception
     */
    @Override
    public ScanPayResult scanPay(PaymentVO vo) throws Exception {
        log.info(">>>>>>>>>>>聚合支付扫码支付开始===================START=================");
        log.info(">>>>>>>>>>>>【"+ PayContants.CLASS_NAME+"】 scanPay start ,入参PaymentVO:"+JSONObject.toJSONString(vo));

        config = getConfigAndHandlePayType(vo,PayConfig.class);

        String orderNo = "";
        if(vo.getOrderNo().length()>20){
            orderNo = vo.getOrderNo().substring(0,20);
            vo.setOrderNo(orderNo);
        }

        ScanPayResult scanPayResult;

        //获取支付请求参数
        Map<String,String> paramMap = sealRequest(vo);
        log.info(">>>>>>>>>>>>聚合支付扫码支付生成支付请求参数，paramMap:"+paramMap);
        paramMap.put("sign",generatorSign(paramMap,1));

        log.info(">>>>>>>>>>>>聚合支付扫码支付请求参数报文:{}", paramMap);
        Map<String,Object> param = new HashMap<>();
        param.putAll(paramMap);
        String responseStr  = DepositHttpClientUtils.doPostOfFormUrlencoded(config.getPayUrl(),param,null);
        log.info(">>>>>>>>>>>聚合支付扫码支付发起HTTP请求响应结果:{}", responseStr);

        if(StringUtils.isBlank(responseStr)){
            log.info(">>>>>>>>>聚合支付扫码支付发起HTTP请求无响应结果");
            return ScanPayResult.getErrorResult("聚合支付下单发起HTTP请求无响应结果");
        }

        JSONObject jsonObject = JSONObject.parseObject(responseStr);
        if(jsonObject.containsKey(RETURN_CODE) && PayContants.SUCCESS_CODE.equals(jsonObject.getString(RETURN_CODE))){
            //下单成功
            log.info(">>>>>>>>>>聚合支付下单成功！返回参数："+jsonObject.toJSONString());
            String data = jsonObject.getString("data");
            JSONObject jsonData = JSONObject.parseObject(data);
            String payurl = jsonData.getString("payurl");
            scanPayResult = ScanPayResult.getSuccessResult(ScanPayResult.LINK, vo.getUsername(),
                    BigDecimal.valueOf(vo.getAmount()), vo.getOrderNo(), payurl);
        }else{
            log.info(">>>>>>>>>聚合支付下单失败：生成请求form为空");
            scanPayResult = ScanPayResult.getErrorResult(jsonObject.toJSONString());
        }
        if(orderNo != null){
            scanPayResult.setOrderNo(orderNo);
        }
        return scanPayResult;
    }


    /**
     * 组装请求参数
     * @param vo
     * @return
     */
    private Map<String,String> sealRequest(PaymentVO vo)throws Exception {
        log.info(">>>>>>>>>>聚合支付组装请求参数开始===================START=================入参，vo:"+JSONObject.toJSONString(vo));
        Map<String,String> data = new HashMap<>();
        String amount = new DecimalFormat("0.00").format(vo.getAmount());
        //商户号
        data.put("merId",config.getPayMemberid());
        //商户订单号
        data.put("orderId",vo.getOrderNo());
        data.put("orderAmt", amount);//支付金额,请求的价格(单位：元) 可以0.01元
        data.put("channel", vo.getPayType());//通道列表请查看商户后台，或联系商务
        //商品名称，utf-8编码
        data.put("desc","TOP-UP");
        data.put("ip", vo.getIp());//支付用户IP地址,用户支付时设备的IP地址
        data.put("notifyUrl", config.getPayNotifyUrl());//异步通知地址,异步接收支付结果通知的回调地址，通知url必须为外网可访问的url，不能携带参数。
        data.put("returnUrl", vo.getRefererUrl());//同步通知地址,支付成功后跳转到的地址，不参与签名。
        data.put("nonceStr", RandomUtils.generateNumberStr(20));//随机字符串

        return data;

    }

    /**
     * @param data
     * @return
     * @throws Exception
     * @Description 生成支付签名串
     */
    public String generatorSign(Map<String, String> data,Integer type) throws Exception {
        log.info(">>>>>>>>>>聚合支付生成支付签名串开始==================START========================入参data:{}",data);
        Map<String, String> sortMap = new TreeMap<>(data);
        StringBuffer sb = new StringBuffer();
        Iterator<String> iterator = sortMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String val = sortMap.get(key);
            if (StringUtils.isBlank(val) || key.equalsIgnoreCase("sign")) {
                continue;
            }
            sb.append(key).append("=").append(val).append("&");
        }
        sb.append("key=").append(this.config.getMd5Key());
        //生成待签名串
        String singStr = sb.toString();
        log.info(">>>>>>>>>>聚合支付生成待MD5签名串singStr:{}" ,singStr);
        //生成加密串
        String sign = MD5Utils.md5toUpCase_32Bit(sb.toString());
        log.info(">>>>>>>>>>聚合支付生成MD5签名串sign:{}" , sign);
        if(type==1){//支付签名
            String rsaSign = SHA256WithRSAUtils.buildRSASignByPrivateKey(sign,SIGN_PRIVATE_KEY);
            log.info(">>>>>>>>>>聚合支付生成RSA2签名串rsaSign:{}" , rsaSign);
            return rsaSign;
        }
       return sign;

    }
  

    @Override
    public String notify(HttpServletRequest request, HttpServletResponse response, JSONObject config) throws Exception {
        log.info(">>>>>>>>>>>>聚合支付回调请求==================START===============");
        //获取回调请求参数
        Map<String, String> infoMap = ParamsUtils.getNotifyParams(request);

        log.info(">>>>>>>>>>>>聚合支付回调请求参数:{}",infoMap);
        if (infoMap == null || infoMap.isEmpty()) {
            log.error(">>>>>>>>>>>>聚合支付获取回调请求参数为空");
            return PayContants.FAIL;
        }
        //参数验签，从配置中获取
        this.config.setMd5Key(config.getString("md5Key"));
        this.config.setPayMemberid(config.getString("payMemberid"));
        this.config.setOrderQueryUrl(config.getString("orderQueryUrl"));

        //回调验签
        boolean verifyRequest = verifyCallback(infoMap);

        // 订单号
        String orderNo = infoMap.get("orderId");
        // 交易流水号
        String tradeNo = infoMap.get("sysOrderId");
        //订单状态
        String tradeStatus = infoMap.get("status");
        // 表示成功状态
        String tTradeStatus = PayContants.SUCCESS_CODE;
        if (!tTradeStatus.equals(tradeStatus)){
            log.info(">>>>>>>>>>聚合支付校验订单状态失败!回调订单状态与成功状态不一致！");
            return PayContants.FAIL;
        }
        //实际支付金额
        String orderAmount = infoMap.get("orderAmt");
        if (StringUtils.isBlank(orderAmount)) {
            log.info(">>>>>>>>>>>>聚合支付获取实际支付金额为空!");
            return PayContants.FAIL;
        }
        double realAmount = Double.parseDouble(orderAmount);
        String ip = IPUtils.getIp(request);
        log.info(">>>>>>>>>>>>>聚合东川支付回调接口：回调IP：{} ，配置IP：{}",ip,config.getString("notifyIp"));

        //调用支付方订单查询接口，获取订单支付状态
        if(!serchOrder(orderNo)){
            log.info(">>>>>>>>>>>>聚合支付回调订单{}查询失败!",orderNo);
            return PayContants.FAIL;
        }


        ProcessNotifyVO processNotifyVO = new ProcessNotifyVO();
        //成功返回
        processNotifyVO.setRetSuccess(PayContants.SUCCESS);
        processNotifyVO.setConfig(config);
        //失败返回
        processNotifyVO.setRetFailed(PayContants.FAIL);
        processNotifyVO.setIp(ip);
        processNotifyVO.setOrder_no(orderNo);
        processNotifyVO.setTrade_no(tradeNo);
        processNotifyVO.setTrade_status(tradeStatus);
        processNotifyVO.setT_trade_status(tTradeStatus);
        processNotifyVO.setRealAmount(realAmount);
        //回调参数
        processNotifyVO.setInfoMap(JSONObject.toJSONString(infoMap));
        processNotifyVO.setPayment(PayContants.CODE);

        return super.processSuccessNotify(processNotifyVO, verifyRequest);
    }

    /**
     * 东川支付回调验签
     * @param data
     * @return
     */
    private boolean verifyCallback(Map<String, String> data) {
        log.info(">>>>>>>>>>>聚合支付回调验签开始==============START===========");

        //获取回调通知原签名串
        String sourceSign = data.get("sign");
        log.info(">>>>>>>>>>>聚合支付回调验签获取原签名串:{}", sourceSign);
        //生成验签签名串
        String sign = null;
        try {
            sign = generatorSign(data,2);
            log.info(">>>>>>>>>>>聚合支付回调验签生成加密串:{}", sign);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(">>>>>>>>>>>聚合支付生成加密串异常:{}", e.getMessage());
        }
        return SHA256WithRSAUtils.buildRSAverifyByPublicKey(sign,SIGN_PUBLIC_KEY,sourceSign);

    }

    /**
     * 调用支付方订单查询接口，获取订单支付状态
     * @param orderNo
     * @return
     */
    private boolean serchOrder(String orderNo){
        log.info(">>>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态开始，入参orderNo:{}",orderNo);
        try {
            Map<String,String> orderMap = new HashMap<>();
            orderMap.put("merId",config.getPayMemberid());//商号,商户编号
            orderMap.put("orderId",orderNo);//在商户系统中保持唯一 商户订单号
            orderMap.put("nonceStr",RandomUtils.generateNumberStr(20));//随机字符串

            //生成签名串
            String signStr = generatorSign(orderMap,1);
            log.info(">>>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态开始，生成签名串signStr:{}",signStr);
            orderMap.put("sign",signStr);

            Map<String,Object> param = new HashMap<>();
            param.putAll(orderMap);

            log.info(">>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态开始请求参数报文:{}", JSONObject.toJSONString(param));
            String responseStr = DepositHttpClientUtils.doPostOfFormUrlencoded(config.getOrderQueryUrl(), param, null);
            log.info(">>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态发起HTTP请求响应结果:{}", responseStr);

            if (StringUtils.isBlank(responseStr)) {
                log.info(">>>>>>>>>聚合支付回调订单查询发起HTTP请求无响应,订单号{}", orderNo);
                return false;
            }

            JSONObject jsonObject = JSONObject.parseObject(responseStr);
            if (!jsonObject.containsKey(RETURN_CODE)&& PayContants.SUCCESS_CODE.equals(jsonObject.getString(RETURN_CODE))) {
                return false;
            }
            //订单状态查询成功
            String data = jsonObject.getString("data");
            String status = JSONObject.parseObject(data).getString("status");
            if (!PayContants.SUCCESS_CODE.equals(status)) {
                log.info(">>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态与订单成功状态不一致!订单号:{},支付状态:{}" , orderNo , status);
                return false;
            }
            log.info(">>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态成功，支付成功!订单号:{},支付状态:{}" , orderNo , status);
            return true;
        }catch (Exception e){
            log.error(">>>>>>>>>>聚合支付调用支付方订单查询接口，获取订单支付状态系统异常!订单号:{},错误信息:{}",orderNo,e.getMessage());
            return false;
        }
    }
}
